/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.rcs.modemcfg;

import com.ibm.hwmca.base.custinfo.CustomerInfoData;
import com.ibm.hwmca.base.custinfo.CustomerInfoManager;
import com.ibm.hwmca.fw.persist.Persistable;
import com.ibm.hwmca.fw.persist.PersistenceException;
import com.ibm.hwmca.fw.persist.PersistentData;
import com.ibm.hwmca.fw.rcs.RcsControl;
import com.ibm.hwmca.fw.util.Trace;

public class ModemConfigData
implements Persistable {
    private static final String TRACE_MASKT = "XRCSMCDT";
    private static final String TRACE_MASKF = "XRCSMCDF";
    private static final String TRACE_MASKD = "XRCSMCDD";
    private int version = 1;
    private int dialType = 0;
    private boolean waitForDialTone = true;
    private boolean enableSpeaker = true;
    private String dialPrefix = "";
    public static final int DIAL_TYPE_TONE = 0;
    public static final int DIAL_TYPE_PULSE = 1;
    public static final String ATCMD_ATTENTION = "AT";
    public static final String ATCMD_DCD_ALWAYS_ON = "&C0";
    public static final String ATCMD_DCD_TRACK = "&C1";
    public static final String ATCMD_DIAL_PULSE = "DP";
    public static final String ATCMD_DIAL_TONE = "DT";
    public static final String ATCMD_DTR_2 = "&D2";
    public static final String ATCMD_SPEAKER_OFF = "M0";
    public static final String ATCMD_SPEAKER_ON_DIAL = "M1";
    public static final String ATCMD_SPEAKER_ON_ALWAYS = "M2";
    public static final String ATCMD_SPEAKER_ON_ANSWER = "M3";
    public static final String ATCMD_SPEAKER_VOLUME_OFF = "L0";
    public static final String ATCMD_SPEAKER_VOLUME_LOW = "L1";
    public static final String ATCMD_SPEAKER_VOLUME_MEDIUM = "L2";
    public static final String ATCMD_SPEAKER_VOLUME_HIGH = "L3";
    public static final String ATCMD_TONE_DETECT_DISABLE = "X3";
    public static final String ATCMD_TONE_DETECT_ENABLE = "X4";
    public static final String ATCMD_ERROR_CORRECTION_NORMAL = "&E0";
    public static final String ATCMD_HW_FLOW_CONTROL_ON = "&E4";

    public ModemConfigData() {
    }

    protected ModemConfigData(PersistentData data) throws PersistenceException {
        Persistent persistent = (Persistent)data;
        this.version = persistent.version;
        this.dialType = persistent.dialType;
        this.waitForDialTone = persistent.waitForDialTone;
        this.enableSpeaker = persistent.enableSpeaker;
        this.dialPrefix = persistent.dialPrefix;
    }

    public PersistentData getPersistentData() {
        Persistent persistent = new Persistent();
        persistent.version = this.version;
        persistent.dialType = this.dialType;
        persistent.waitForDialTone = this.waitForDialTone;
        persistent.enableSpeaker = this.enableSpeaker;
        persistent.dialPrefix = this.dialPrefix;
        return persistent;
    }

    public boolean isUpgradeData() {
        return true;
    }

    public int getDialType() {
        return this.dialType;
    }

    public void setDialType(int type) throws IllegalArgumentException {
        if (!this.isDialTypeValid(type)) {
            throw new IllegalArgumentException("Invalid dial type");
        }
        this.dialType = type;
    }

    private boolean isDialTypeValid(int type) {
        switch (type) {
            case 0: {
                return true;
            }
            case 1: {
                return true;
            }
        }
        return false;
    }

    public boolean isWaitForDialTone() {
        return this.waitForDialTone;
    }

    public void setWaitForDialTone(boolean value) {
        this.waitForDialTone = value;
    }

    public boolean isEnableSpeaker() {
        return this.enableSpeaker;
    }

    public void setEnableSpeaker(boolean value) {
        this.enableSpeaker = value;
    }

    public String getDialPrefix() {
        return this.dialPrefix;
    }

    public void setDialPrefix(String prefix) {
        if (prefix == null) {
            throw new IllegalArgumentException("Null dial prefix specified");
        }
        this.dialPrefix = prefix;
    }

    public String getDialModeString() {
        Trace.trace(TRACE_MASKT, "-> getDialModeString()");
        StringBuffer sb = new StringBuffer();
        sb.append(ATCMD_ATTENTION);
        if (this.dialType == 0) {
            sb.append(ATCMD_DIAL_TONE);
        } else {
            sb.append(ATCMD_DIAL_PULSE);
        }
        String dialModeString = sb.toString();
        Trace.trace(TRACE_MASKT, "<- getDialModeString() " + dialModeString);
        return dialModeString;
    }

    public String getInitString() {
        Trace.trace(TRACE_MASKT, "-> getInitString()");
        StringBuffer sb = new StringBuffer();
        sb.append(ATCMD_ATTENTION);
        sb.append("&F");
        sb.append(ATCMD_DTR_2);
        sb.append(ATCMD_DCD_TRACK);
        if (RcsControl.getModemType() == 2) {
            CustomerInfoManager custInfoMgr = CustomerInfoManager.getCustomerInfoManager();
            CustomerInfoData custInfo = custInfoMgr.getCustomerInfo();
            sb.append(this.getMultiTechCountryATCmd(custInfo.getSystemCountryCode()));
        }
        String initString = sb.toString();
        Trace.trace(TRACE_MASKT, "<- getInitString() " + initString);
        return initString;
    }

    private String getMultiTechCountryATCmd(String isoCtryCode) {
        Trace.trace(TRACE_MASKT, "-> getMultiTechCountryATCmd(" + isoCtryCode + ")");
        StringBuffer sb = new StringBuffer("%T19,0,");
        if (isoCtryCode == null || isoCtryCode.equals("")) {
            sb.append("34");
        } else if (isoCtryCode.equals("AU")) {
            sb.append("1");
        } else if (isoCtryCode.equals("CZ")) {
            sb.append("25");
        } else if (isoCtryCode.equals("HK")) {
            sb.append("30");
        } else if (isoCtryCode.equals("HU")) {
            sb.append("30");
        } else if (isoCtryCode.equals("ID")) {
            sb.append("30");
        } else if (isoCtryCode.equals("IL")) {
            sb.append("30");
        } else if (isoCtryCode.equals("IN")) {
            sb.append("30");
        } else if (isoCtryCode.equals("JP")) {
            sb.append("10");
        } else if (isoCtryCode.equals("KR")) {
            sb.append("30");
        } else if (isoCtryCode.equals("MY")) {
            sb.append("30");
        } else if (isoCtryCode.equals("NZ")) {
            sb.append("9");
        } else if (isoCtryCode.equals("PH")) {
            sb.append("30");
        } else if (isoCtryCode.equals("PL")) {
            sb.append("30");
        } else if (isoCtryCode.equals("SG")) {
            sb.append("30");
        } else if (isoCtryCode.equals("SI")) {
            sb.append("30");
        } else if (isoCtryCode.equals("VN")) {
            sb.append("30");
        } else if (isoCtryCode.equals("ZA")) {
            sb.append("35");
        } else {
            sb.append("34");
        }
        String atCmd = sb.toString();
        Trace.trace(TRACE_MASKT, "<- getMultiTechCountryATCmd() " + atCmd);
        return atCmd;
    }

    public String getPostInitString() {
        Trace.trace(TRACE_MASKT, "-> getPostInitString()");
        StringBuffer sb = new StringBuffer();
        sb.append(ATCMD_ATTENTION);
        sb.append(ATCMD_ERROR_CORRECTION_NORMAL);
        sb.append(ATCMD_HW_FLOW_CONTROL_ON);
        sb.append("S0=0");
        if (this.waitForDialTone) {
            sb.append(ATCMD_TONE_DETECT_ENABLE);
        } else {
            sb.append(ATCMD_TONE_DETECT_DISABLE);
        }
        if (this.enableSpeaker) {
            sb.append(ATCMD_SPEAKER_ON_DIAL);
            sb.append(ATCMD_SPEAKER_VOLUME_HIGH);
        } else {
            sb.append(ATCMD_SPEAKER_OFF);
        }
        String postInitString = sb.toString();
        Trace.trace(TRACE_MASKT, "<- getPostInitString() " + postInitString);
        return postInitString;
    }

    public String getAnswerInitString() {
        Trace.trace(TRACE_MASKT, "-> getAnswerInitString()");
        StringBuffer sb = new StringBuffer();
        sb.append(ATCMD_ATTENTION);
        sb.append(ATCMD_ERROR_CORRECTION_NORMAL);
        sb.append(ATCMD_HW_FLOW_CONTROL_ON);
        sb.append("S0=2");
        String answerInitString = sb.toString();
        Trace.trace(TRACE_MASKT, "<- getAnswerInitString() " + answerInitString);
        return answerInitString;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("[ModemConfigData: ");
        sb.append("dialType=" + this.dialType + ", ");
        sb.append("waitForDialTone=" + this.waitForDialTone + ", ");
        sb.append("enableSpeaker=" + this.enableSpeaker + ", ");
        sb.append("dialPrefix=" + this.dialPrefix + "]");
        return sb.toString();
    }

    private static class Persistent
    implements PersistentData {
        private static final long serialVersionUID = -982140128466695890L;
        int version;
        int dialType;
        boolean waitForDialTone;
        boolean enableSpeaker;
        String dialPrefix;

        private Persistent() {
        }
    }
}

